{-----------------------------------------------------------------------}
{ Copyright  1995 by Software Source. All Rights Reserved              }
{ Delphi conversion by Gregg Irwin [72450,676]                          }
{                                                                       }
{ The biggest thing to be aware of when using CB/ISAM with Delphi is    }
{ how strings are handled. A char array in C maps to an array of chars  }
{ in Delphi (makes sense, eh?). Delphi strings (e.g. String[20]) work   }
{ fine in most cases. The one place they won't work is on indexed       }
{ fields. This is because Pascal strings are length prefixed so longer  }
{ strings sort lower, which obviously isn't correct. For this reason    }
{ you should only use arrays of chars for indexed fields. Pascal        }
{ strings are generally much more convenient to use however so you can  }
{ use them in all other cases if you so desire.                         }
{                                                                       }
{ IMPORTANT NOTE: Not all functions have been tested to ensure their    }
{                 correctness under Delphi. The basic stuff works but   }
{                 if you should run into any problems don't be too      }
{                 surprised and please let Software Source know about   }
{                 them. That's the only way they'll know.<g> GI         }
{-----------------------------------------------------------------------}

unit CBISAM;

interface

{ structures }
type
  PCBISAMINFO = ^T_CBISAMINFO;
  T_CBISAMINFO = record
    lRecordsInFile:         LongInt;
    nGroupsUsed:            Integer;
    nAllocatedGpsAvail:     Integer;
    nMaxPrimaryKeyLen:      Integer;
    lGroupSize:             LongInt;
    nInitialAllocation:     Integer;
    nIncrementalAllocation: Integer;
    nFreeFileNoteSpace:     Integer;
    szStandardFormat:       array[0..255] of char;
    szReserved:             array[0..255] of char;
  end;

type
  PVSTR = ^T_VSTR;
  T_VSTR = record
    nLen:      Word;
    lpData:    Pointer;
  end;

type
  PVBUFCB = ^T_VBUFCB;
  T_VBUFCB = record
    bufcb:     array[0..11] of char;
  end;

type
  PENCODEDEST = ^T_ENCODEDEST;
  T_ENCODEDEST = record
    VBufCB:    T_VBUFCB;
    estr:      T_VSTR;   { variable length string with encoded data }
  end;

function VmxCreate(lpszDatasetName:   PChar;
                   nMaxPrimaryKeyLen: Integer;
                   lGpSz:             LongInt;
                   nInitAlloc:        Integer;
                   nIncrAlloc:        Integer;
                   lpszStandardFormatString: PChar): Integer;

function VmxKill(lpszDatasetName: PChar): Integer;

function VmxOpen(lpszDatasetName: PChar;
                 nCacheSize:  Integer;
                 nAccessMode: Integer;
                 var lpnRDatasetNumber: Integer): Integer;

function VmxClose(nDatasetNumber: Integer): Integer;

function VmxGet(nDatasetNumber:         Integer;
                nIndex:                 Integer;
                wOptions:               Word;
                lpszSelector:           PChar;
                lpszRIndexEntry:        PChar;
                lpszPrimaryKey:         PChar;
                lpDestinationStructure: Pointer;
                wLengthOfDestinationStructure: Word): Integer;

function VmxPut(nDatasetNumber:           Integer;
                lpszPrimaryKey:           PChar;
                lpSourceStructure:        Pointer;
                wLengthOfSourceStructure: Word;
                wOptions:                 Word): Integer;

function VmxDelete(nDatasetNumber: Integer;
                   lpszPrimaryKey: PChar): Integer;

function VmxBOF(nDatasetNumber, nIndex: Integer): Integer;
function VmxEOF(nDatasetNumber, nIndex: Integer): Integer;

function VmxWriteNote(nDatasetNumber:       Integer;
                      lpszNoteName:         PChar;
                      lpszNoteContents:     PChar): Integer;

function VmxReadNote(nDatasetNumber:        Integer;
                     lpszNoteName:          PChar;
                     lpszRNoteContents:     PChar;
                     wLengthOfResultBuffer: Word): Integer;

function VmxFlush(nDatasetNumber: Integer): Integer;

function VmxInfo(nDatasetNumber: Integer;
                 var lpRInfoStructure: T_CBISAMINFO): Integer;

function VmxReturnCode(nInteger: Integer;
                       lpszResultBuffer: PChar): Pointer;

function VmxEncode(lpSourceStructure:             Pointer;
                   wLengthOfSourceStructure:      Word;
                   lpszFormatString:              PChar;
                   var lpRDestinationStructure:   T_ENCODEDEST;
                   wStringHandlingMode: Word):    Integer;

function VmxDecode(var lpSourceVstr:              T_VSTR;
                   lpszFormatString:              PChar;
                   lpRDestinationStructure:       Pointer;
                   wLengthOfDestinationStructure: Word;
                   wStringHandlingMode: Word):    Integer;

function VmxFreeBuf(var lpTargetStruct: T_VBUFCB): Integer;
function VmxLock(nDatasetNumber: Integer; lpszLockString: PChar): Integer;
function VmxUnlock(nDatasetNumber: Integer; lpszLockString: PChar): Integer;

const

{ return codes }
VIS_OK                    = 0;
VIS_NOT_FOUND             = 1;
VIS_UPDATE_VIOLATION      = 2;
VIS_ACCESS_DENIED         = 3;
VIS_BAD_HANDLE            = 4;
VIS_BAD_FORMAT            = 5;
VIS_INVALID_KEY           = 6;
VIS_BAD_PARAMETER_VALUE   = 7;
VIS_BAD_FILE              = 8;
VIS_ALREADY_EXISTS        = 9;
VIS_NO_ROOM               = 10;
VIS_DISK_FULL             = 11;
VIS_OUT_OF_MEMORY         = 12;
VIS_DOS_ERROR             = 13;
VIS_DISK_ERROR            = 14;
VIS_DATA_VALIDITY_CHECK   = 15;
VIS_INVALID_SECONDARY_KEY = 16;
VIS_SEQUENCE_ERROR        = 17;
VIS_OUT_OF_FILE_HANDLES   = 18;
VIS_BUSY                  = 19;

{ open modes }
VMODE_RO                  = 0;
VMODE_RW                  = 1;
VMODE_RO_SHARE            = 2;
VMODE_RO_SHARED           = 2;
VMODE_RW_SHARE            = 3;
VMODE_RW_SHARED           = 3;

{ flags for VmxOpen }
SMALL_CACHE               = 0;
LARGE_CACHE               = 1;

{ flags for both VmxGet and VmxPut }
XTEXT                     = $4000; { zero terminated fixed len strings }
XBINARY                   = $8000; { blank pad fixed len strings }

{ flags for VmxGet }
XLOOKUP                   = $0001;
XNEXT                     = $0002;
XPREVIOUS                 = $0004;
XCURRENT                  = $0008;

XANY                      = $0010;
XEQ                       = $0020;
XBEGINS                   = $0040;

XNOT                      = $0080;
XLT                       = $0100;
XGT                       = $0200;
XLE                       = $0400;
XGE                       = $0800;

XGET_DATA                 = $1000; { get both primary key and data }
XNO_DATA                  = $2000; { do not return data }

{ flags for VmxPut }
ADD_ONLY                  = $0001;
REPLACE_ONLY              = $0002;
ADD_OR_REPLACE            = $0004;


implementation

function	vmxCreate;                external 'CBISAMMU'    index 2;
function	vmxKill;                  external 'CBISAMMU'    index 3;
function	vmxOpen;                  external 'CBISAMMU'    index 4;
function	vmxClose;                 external 'CBISAMMU'    index 5;
function	vmxGet;                   external 'CBISAMMU'    index 6;
function	vmxPut;                   external 'CBISAMMU'    index 7;
function	vmxDelete;                external 'CBISAMMU'    index 8;
function	vmxBOF;                   external 'CBISAMMU'    index 9;
function	vmxEOF;                   external 'CBISAMMU'    index 10;
function	vmxWriteNote;             external 'CBISAMMU'    index 11;
function	vmxReadNote;              external 'CBISAMMU'    index 12;
function	vmxFlush;                 external 'CBISAMMU'    index 13;
function	vmxInfo;                  external 'CBISAMMU'    index 14;
function	vmxReturnCode;            external 'CBISAMMU'    index 15;
function	vmxEncode;                external 'CBISAMMU'    index 16;
function	vmxDecode;                external 'CBISAMMU'    index 17;
function	vmxLock;                  external 'CBISAMMU'    index 19;
function	vmxUnlock;                external 'CBISAMMU'    index 20;
function	vmxFreeBuf;               external 'CBISAMMU'    index 36;
{ function	vmxHaltOnImpendingError;  external 'CBISAMMU'    index 37; }
{ function	vmxExtendedError;         external 'CBISAMMU'    index 38; }

end.
